﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AdmPracownicyFunkcjeWybierz.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.AdmPracownicyFunkcjeWybierz" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Wybierz pracownika</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
          $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
          $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
          $(".btnWybierzGrid").button({ icons: { primary: 'ui-icon-check' } });

        });
    </script>
</head>
<body>
  <form id="form1" runat="server">
    <div>
      <table class="Body" border="0" cellspacing="5px" cellpadding="0" width="100%">
        <tr>
          <td colspan="6">
            <asp:Label ID="lblOpis" runat="server" Font-Size="Medium" Font-Bold="True">Wybierz pracownika</asp:Label>
          </td>
        </tr>
        <tr>
          <td colspan="6">
            <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label></td>
        </tr>
        <tr>
          <td style="width: 15%">
            <small>Nazwisko</small><br />
            <asp:TextBox ID="tbNazwisko" runat="server" Width="95%"></asp:TextBox></td>
          <td style="width: 15%">
            <small>Imię</small><br />
            <asp:TextBox ID="tbImie" runat="server" Width="95%"></asp:TextBox></td>
          <td style="width: 35%">
            <small>Jednostka</small><br />
            <asp:DropDownList ID="ddlJednostka" runat="server" Width="95%"></asp:DropDownList>
          </td>
          <td style="width: 15%">
            <small>&nbsp;</small><br />
            <asp:CheckBox ID="cbAktywni" runat="server" Text="Aktywni" Checked="True" />
          </td>
          <td style="width: 10%">
            <small>&nbsp;</small><br />
            <asp:LinkButton ID="btnOdswiez" runat="server" Width="90px" CssClass="Button" Text="Odśwież" OnClick="btnOdswiez_Click"></asp:LinkButton>
          </td>
          <td style="width: 10%; text-align: right">
            <small>&nbsp;</small><br />
            <asp:LinkButton ID="btnPowrot" runat="server" Width="90px" CssClass="Button" Text="Powrót" OnClick="btnPowrot_Click"></asp:LinkButton>
          </td>
        </tr>

      </table>
    </div>
    <div>
      <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
        <div style="float: left; position: absolute; bottom: 2px;">
          <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
        </div>
      </div>
      <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_PRACOWNIKA,NAZWISKO,IMIE,JEDNOSTKA,STANOWISKO" OnRowCommand="gvListy_RowCommand">
        <Columns>
          <asp:TemplateField ShowHeader="False">
            <ItemTemplate>
              <asp:LinkButton ID="lbOtworzGrid" class="btnWybierzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>' Text="Wybierz" Width="100px"></asp:LinkButton>
            </ItemTemplate>
            <ItemStyle VerticalAlign="Middle" />
          </asp:TemplateField>
          <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
          <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
          <asp:BoundField DataField="NR_KARTOTEKI" HeaderText="Nr kartoteki" SortExpression="NR_KARTOTEKI" />
          <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
          <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
        </Columns>
        <PagerSettings Position="Top" />
        <RowStyle CssClass="TableItem" />
        <SelectedRowStyle CssClass="TableItemSelected" />
        <HeaderStyle CssClass="TableHeader" />
        <AlternatingRowStyle CssClass="TableItemAlt" />
      </asp:GridView>
      <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="PRACOWNICY_FUNKCJE_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" OnSelecting="sdsListy_Selecting">
        <SelectParameters>
          <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
          <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
          <asp:SessionParameter Name="P_KOD_FUNKCJI" SessionField="PRACOWNICY_FUNKCJE_KOD_FUNKCJI" />
          <asp:Parameter Name="P_AKTUALNE" Type="string" Direction="Input" />
        </SelectParameters>
      </asp:SqlDataSource>
    </div>
  </form>
</body>
</html>
